<?php

use App\Http\Controllers\AccountControllers\AccountController;
use App\Http\Controllers\Alarm_PersonController;
use App\Http\Controllers\AlarmController;
use App\Http\Controllers\AuthController\LoginController;
use App\Http\Controllers\AuthController\RegisterController;
use App\Http\Controllers\AuthController\ResetPasswordController;
use App\Http\Controllers\CameraControllers\CameraController;
use App\Http\Controllers\Client_Auth_itemController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ClienteController;
use App\Http\Controllers\Download_videoController;
use App\Http\Controllers\GeoLocationController;
use App\Http\Controllers\Integrator_Auth_itemController;
use App\Http\Controllers\AuditoriaController;
use App\Http\Controllers\PlateController;
use App\Http\Controllers\IdFacialController;
use App\Http\Controllers\IntegratorController;
use App\Http\Controllers\LogAlarmController;
use App\Http\Controllers\LogController;
use App\Http\Controllers\SystemController;
use App\Http\Controllers\Parameters\CityController;
use App\Http\Controllers\Parameters\DistrictController;
use App\Http\Controllers\Parameters\StateController;
use App\Http\Controllers\Parameters\NeighborhoodController;
use App\Http\Controllers\Parameters\GroupController;
use App\Http\Controllers\PlateRecognitionController;
use App\Http\Controllers\PlateRecognitionControllerLinux;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\VideoVerificationControllers\MapaController;
use App\Http\Controllers\VideoVerificationControllers\EventController;
use App\Http\Controllers\VideoVerificationControllers\BrivoController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;


/* Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
}); */

//Route::apiResource('users', UserController::class);
Route::apiResource('clientes', ClienteController::class);

Route::get('/third-party-cameras/{account}', [CameraController::class, 'getCamerasFromThirdParty']);

//Rutas AuthController
// Route::post('/login', [LoginController::class,'login']);
Route::post('/login', [LoginController::class,'login']);
Route::post('/sendEmailResetPassword', [ResetPasswordController::class, 'sendEmailResetPassword']);
Route::post('/resetPassword', [ResetPasswordController::class, 'resetPassword']);
Route::post('/logout', [LoginController::class,'logout']);


//Route::get('/getSession', [LoginController::class,'getSession']);



Route::middleware('auth:sanctum')->get('/check-auth', function () {
    return response()->json(['user' => Auth::user()]);
});

//Rutas UserController
// routes/api.php
Route::middleware('auth:sanctum')->group(function () {

    Route::post('/imp', [LoginController::class,'impersonate']);
    Route::post('/revImp', [LoginController::class,'revertImpersonation']);
   
    Route::get('/getSession', [LoginController::class,'getSession']);
   
    Route::controller(UserController::class)->group(function () {
        Route::get('/users/{id}', 'getUserById');
        Route::get('/users', 'getUsers');
        Route::post('/users', 'updateUser');
        Route::post('/registerUser', 'registerUser');
        /* Route::post('/verifyUserEmail', 'verifyUserEmail'); */
        Route::post('/deleteUser', 'deleteUser');
    });

    //Rutas IntegratorController
    Route::controller(IntegratorController::class)->group(function () {
        Route::get('/integrators/{id}', 'getIntegratorById');
        Route::get('/integrators', 'getIntegrators');
        Route::post('/integrators', 'updateIntegrator');
        Route::post('/registerIntegrator', 'registerIntegrator');
        Route::post('/deleteIntegrator', 'deleteIntegrator');
    });

    //Rutas IntegratorController
    Route::controller(ClientController::class)->group(function () {
        Route::get('/clients/{id}', 'getClientById');
        Route::get('/clients', 'getClients');
        Route::post('/updateClient', 'updateClient');
        Route::post('/registerClient', 'registerClient');
        Route::post('/deleteClient', 'deleteClient');
    });

    Route::get('/integratorPermissions/{id}', [Integrator_Auth_itemController::class,'getIntegrator_Auth_itemsById']);
    Route::get('/clientPermissions/{id}', [Client_Auth_itemController::class,'getClient_Auth_itemsById']);

    Route::controller(AccountController::class)->group(function () {
        Route::get('/accounts/{id}', 'getAccountById');
        Route::get('/accounts', 'getAccounts');
        Route::post('/updateAccount', 'updateAccount');
        Route::post('/registerAccount', 'registerAccount');
        Route::post('/deleteAccount', 'deleteAccount');
    });
    //Rutas AccountController
    
    //Rutas CameraController
    Route::controller(CameraController::class)->group(function () {
        Route::get('/cameras/{id}', 'getCameraById');
        Route::get('/cameras', 'getAllCameras');
        Route::post('/camerasByIntegrator', 'getCamerasByIntegrator');
        Route::post('/camerasByClient', 'getCamerasByClient');
        Route::post('/camerasByCity', 'getCamerasByCity');
        Route::post('/camerasByDistrict', 'getCamerasByDistrict');
        Route::post('/camerasByImei', 'getCamerasByAlarmAndClient');
        Route::post('/cameras/urlStream', 'getUrlStream');
        Route::post('/cameras/downloadVideo', 'downloadVideo');
        Route::post('/stopStream', 'stopStream');
        Route::post('/updateCamera', 'updateCamera');
        Route::post('/cameras/playBackVideo', 'playBackVideo');
        Route::post('/cameras/alarmEventVideo', 'alarmEventVideo');
        Route::post('/deleteCamera', 'deleteCamera');
        Route::post('/cameras/zoom', 'zoomInAndOut');
    });

    //Rutas AlarmController
    Route::controller(AlarmController::class)->group(function () {
        Route::get('/alarms', 'getAllAlarms');
        Route::post('/registerAlarm', 'registerAlarm');
        Route::post('/updateAlarm', 'updateAlarm');
        Route::post('/deleteAlarm', 'deleteAlarm');
        Route::post('alarms/alarmByImei', 'getAlarmByImei');
        Route::get('/alarms/getalarmByImei', 'getAlarmByImeiParams');
        Route::post('alarms/alarmsByUser', 'getAlarmsByUser');
        Route::post('alarms/activateAlarm', 'activateAlarm');
        Route::post('alarms/activateAlarmApp', 'activateAlarmApp');
        Route::post('alarms/resetAlarm', 'resetAlarm');
        Route::get('/videoverification/maps/coords', 'getCoords');
    });

    //Rutas Alarm_Person
    Route::controller(Alarm_PersonController::class)->group(function () {
        Route::post('alarms/registerPerson', 'registerAlarm_Person');
        Route::post('alarms/createPersonFromAlarm', 'createAlarmPersonFromAlarm');
        Route::post('alarms/deletePersonFromAlarm', 'deletePersonFromAlarm');
        Route::post('alarms/registerPanic', 'registerPanicFromAlarm');
        Route::post('alarms/personsByImei', 'getPersonsByImei');
        Route::post('alarms/deletePerson', 'deletePerson');
        Route::post('alarms/downloadDocument', 'downloadAuthorizationDoc');
        Route::get('alarms/active', 'activate');
    });

    //Rutas GeoLocation
    Route::post('/geoLocation', [GeoLocationController::class,'getLocation']);

    //Parameter
    //States
    Route::get('/parameters/states', [StateController::class,'getStates']);
    //Cities
    Route::post('/parameters/cities/state', [CityController::class,'getCitiesByState']);
    Route::get('/parameters/cities', [CityController::class,'searchCities']);
    Route::post('/parameters/cities', [CityController::class,'saveAndUpdateCity']);
    Route::delete('/parameters/deleteCity', [CityController::class,'deleteCity']);
    //districts
    Route::post('/parameters/districts/city', [DistrictController::class,'getDistrictsByCity']);
    Route::get('/parameters/districts', [DistrictController::class,'searchDistricts']);
    Route::post('/parameters/districts', [DistrictController::class,'saveAndUpdateDistrict']);
    Route::delete('/parameters/deleteDistrict', [DistrictController::class,'deleteDistrict']);
    //Neighborhood
    Route::post('/parameters/neighborhood', [NeighborhoodController::class,'saveAndUpdateNeighborhood']);
    Route::post('/parameters/deleteNeighborhood', [NeighborhoodController::class,'deleteNeighborhood']);
    Route::get('/parameters/neighborhood', [NeighborhoodController::class,'searchNeighborhood']);
    //Groups
    Route::get('/parameters/groups/all', [GroupController::class,'getGroupsAll']);
    Route::get('/parameters/groups', [GroupController::class,'getGroupsPagination']);
    Route::post('/parameters/groups', [GroupController::class,'saveAndUpdateGroup']);
    Route::delete('/parameters/deleteGroups', [GroupController::class,'deleteGroup']);
    Route::get('/parameters/groups/search', [GroupController::class,'searchGroups']);


    //VideoVerificacion
    Route::get('/videoverification/maps', [MapaController::class,'searchMapas']);
    Route::get('/videoverification/maps/client', [MapaController::class,'searchMapasByUser']);
    Route::get('/videoverification/events/notifications', [MapaController::class,'searchNotifications']);
    Route::get('/videoverification/events', [EventController::class,'searchEvents']);
    Route::post('/videoverification/brivoEvents', [BrivoController::class,'searchBrivoEvents']);
    Route::get('/videoverification/maps/coords/client', [MapaController::class,'getCoordsByClient']);
    Route::get('/videoverification/maps/coords/alarm', [MapaController::class,'getCoordsByAlarm']);
    Route::get('/videoverification/maps/coords/camera', [MapaController::class,'getCoordsByCamera']);
    Route::get('/videoverification/maps/coords/client/months', [MapaController::class,'getCoordsByClientAndMonths']);

 /*    Route::get('/brivo/cameras', [BrivoController::class,'getListCameras']);
    Route::get('/brivo/eventById', [BrivoController::class,'getEventById']); */
    Route::get('/brivo/videoUrl', [BrivoController::class,'getVideoCameraById']);

    //Auditoria
    Route::get('/auditoria/user', [AuditoriaController::class,'searchAuditoriaByUser']);
    Route::get('/auditoria/client', [AuditoriaController::class,'searchAuditoriaByClient']);
    Route::get('/auditoria/integrador', [AuditoriaController::class,'searchAuditoriaByIntegrador']);
    Route::post('/auditoria/createLog', [AuditoriaController::class,'createAuditLog']);
 

    //Reportes

    Route::get('/reports/alarmlogs/client', [ReportController::class,'searchAlarmsLogsByUser']);
   

    //Registro de placas
    Route::get('/plateRegister', [PlateController::class,'searchPlate']);
    Route::get('/plateRegisterComplete', [PlateController::class,'searchPlateComplete']);
    Route::post('/uploadVideo', [PlateController::class, 'upload'])->name('upload');
    Route::post('/procesoVideo', [PlateController::class, 'procesoVideo']);
    //Route::get('/getImage', [PlateController::class, 'getImage']);

    //Route::post('/recognize-plate', [PlateRecognitionController::class, 'recognizePlates']); ///
    Route::post('/recognize-plate', [PlateRecognitionControllerLinux::class, 'recognizePlates']); ///
    Route::post('/updatePlateStatus', [PlateRecognitionControllerLinux::class, 'updatePlateStatus']); ///  
    
    //identificacion Facial
    Route::get('/person', [IdFacialController::class,'searchIDFacial']);

    Route::get('/pruebaSafr', [EventController::class,'synchronizeEvents']);

    Route::get('/pruebaImage', [EventController::class,'getImage']);

    Route::get('/videoDownloadLogs/{id}', [Download_videoController::class,'getVideoDownloadLogsByUser']);

});

Route::get('/brivo/eventById', [BrivoController::class,'getEventById']);
Route::get('/brivo/cameras', [BrivoController::class,'getListCameras']);

//Registro de placas
Route::get('/getImage', [PlateController::class, 'getImage']);

Route::get('logs/getImage', [LogController::class, 'getImage']);

Route::controller(UserController::class)->group(function () {
    Route::post('/verifyUserEmail', 'verifyUserEmail');
});

//exports auditoria
Route::get('/auditoria/export-csv/user', [AuditoriaController::class,'exportCSVByUser'])->name('export.csv');
Route::get('/auditoria/export-csv/client', [AuditoriaController::class,'exportCSVByClient'])->name('export.csv');
Route::get('/auditoria/export-csv/integrador', [AuditoriaController::class,'exportCSVByIntegrador'])->name('export.csv');

// exports reportes
Route::get('/reports/export-csv/client', [ReportController::class,'exportCSVByClient'])->name('Reporte_eventos.csv');
Route::get('/reports/export-pdf/client', [ReportController::class,'exportPdfByClient']);



//Rutas LogAlarmController
Route::controller(LogAlarmController::class)->group(function () {
    Route::post('alarms/alarmFrame', 'alarmFrame');
    Route::post('alarms/alarmFrameOld', 'alarmFrameOld');
    Route::post('alarms/attendEvent', 'attendEvent');
});

//Logs
Route::controller(LogController::class)->group(function () {
    Route::post('logs/alarmLogs', 'getAlarmLogs');
});



Route::controller(Alarm_PersonController::class)->group(function () {
    Route::post('prueba', 'pruebaUserAlarm');
    Route::post('pruebaCreate', 'pruebaCreateUserAlarm');
});

/* Route::controller(AlarmController::class)->group(function () {
    Route::post('alarms/activateAlarmApp', 'activateAlarmApp');
});
 */
//serverInfo
Route::get('/server/info', [SystemController::class,'getServerInfo']);

Route::post('/refresh-token', [LoginController::class, 'refreshToken']);

/* Route::get('/resetPassword', function () {
    return view('reset_password');
});

Route::get('/verifyUserEmail', function () {
    return view('verify_User');
}); */



//Route::post('/login','UserController@login');
